/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.thonkutil.api.events;

import com.jab125.thonkutil.api.Tick;
import com.jab125.thonkutil.api.annotations.SubscribeEvent;
import com.jab125.thonkutil.api.events.EventTaxiEvent;
import com.jab125.thonkutil.api.events.EventTaxiReturnableEvent;
import com.jab125.thonkutil.api.events.server.RegisterCommandEvent;
import com.jab125.thonkutil.api.events.server.ServerStartEvent;
import com.jab125.thonkutil.api.events.server.ServerStopEvent;
import com.jab125.thonkutil.api.events.server.ServerTickEvent;
import com.jab125.thonkutil.api.events.server.player.OnPlayerFatalDamageEvent;
import com.jab125.thonkutil.api.events.server.world.ServerWorldLoadEvent;
import com.jab125.thonkutil.api.events.server.world.ServerWorldUnloadEvent;
import com.jab125.thonkutil.api.events.world.WorldTickEvent;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2168;

public class EventTaxi {
    private static final ArrayList<Class<?>> registeredEventClazzes = new ArrayList();

    public static void registerTaxis() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> EventTaxi.executeEventTaxi(new RegisterCommandEvent((CommandDispatcher<class_2168>)dispatcher, dedicated)));
        ServerPlayerEvents.ALLOW_DEATH.register((player, damageSource, damageAmount) -> (Boolean)EventTaxi.executeEventTaxi(new OnPlayerFatalDamageEvent(player, damageSource, damageAmount)));
        ServerWorldEvents.LOAD.register((minecraftServer, world) -> EventTaxi.executeEventTaxi(new ServerWorldLoadEvent(minecraftServer, world)));
        ServerWorldEvents.UNLOAD.register((server, world) -> EventTaxi.executeEventTaxi(new ServerWorldUnloadEvent(server, world)));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> EventTaxi.executeEventTaxi(new ServerStartEvent(server)));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> EventTaxi.executeEventTaxi(new ServerStopEvent(server)));
        ServerTickEvents.START_SERVER_TICK.register(server -> EventTaxi.executeEventTaxi(new ServerTickEvent(server, Tick.Phase.START)));
        ServerTickEvents.END_SERVER_TICK.register(server -> EventTaxi.executeEventTaxi(new ServerTickEvent(server, Tick.Phase.END)));
        ServerTickEvents.START_WORLD_TICK.register(world -> EventTaxi.executeEventTaxi(new WorldTickEvent((class_1937)world, Tick.Phase.START)));
        ServerTickEvents.END_WORLD_TICK.register(world -> EventTaxi.executeEventTaxi(new WorldTickEvent((class_1937)world, Tick.Phase.END)));
    }

    public static void registerEventTaxiSubscriber(Class<?> clazz) {
        registeredEventClazzes.add(clazz);
    }

    public static void unregisterEventTaxiSubscriber(Class<?> clazz) {
        registeredEventClazzes.remove(clazz);
    }

    public static Object executeEventTaxi(EventTaxiEvent object) {
        return EventTaxi.executeEventTaxi(object, null);
    }

    public static Object executeEventTaxi(EventTaxiEvent event, String target) {
        if (event == null) {
            return null;
        }
        block2: for (SubscribeEvent.Priority priority : new SubscribeEvent.Priority[]{SubscribeEvent.Priority.HIGH, SubscribeEvent.Priority.DEFAULT, SubscribeEvent.Priority.LOW}) {
            for (Class<?> clazz : registeredEventClazzes) {
                Method[] methods;
                block4: for (Method method : methods = clazz.getMethods()) {
                    if (method.getParameterCount() != 1 || !method.getParameters()[0].getType().equals(event.getClass())) continue;
                    for (Annotation declaredAnnotation : method.getDeclaredAnnotations()) {
                        if (!(declaredAnnotation instanceof SubscribeEvent)) continue;
                        SubscribeEvent subscribeEvent = (SubscribeEvent)declaredAnnotation;
                        if (target != null && !subscribeEvent.target().equals(target) || !subscribeEvent.priority().equals((Object)priority)) continue block4;
                        try {
                            if (event.isCancelled()) continue block2;
                            method.invoke(null, event);
                            if (!(event instanceof EventTaxiReturnableEvent)) continue block4;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("failed to execute event taxi");
                        }
                    }
                }
            }
        }
        if (event instanceof EventTaxiReturnableEvent) {
            EventTaxiReturnableEvent eventReturnable = (EventTaxiReturnableEvent)event;
            return eventReturnable.getResult();
        }
        return null;
    }
}

